#!/usr/local/bin/perl

$hostpw = '12345';

$cgi = 'pcalen.cgi';

#------------------------------------------------------------------------------------#
require 'pcalcfg.pl';
require 'jcode.pl';
#------------------------------------------------------------------------------------#
$lockfile = './lock/lockfile';
$annual = 'annual.dat';
$maidat = 'monthly.dat';
$shudat = 'weekly.dat';
$regpl = 'pcalreg.pl';
$hp = 'http://www3.to/kyomi/cgi/pcalen/';
$ver = "<a href=\"$hp\">- PCalen 1.06 -</a>";
$note{'select'} = 'Ij[ɂȂŃApœ͂ĉB<br>( 1583 ` 3999N )';
$err{'year'} = 'ŃA1583`3999 𔼊pœĉB';
$err{'open'}  = 'I[vł܂B';
$err{'enter'} = 'ĉB';
$err{'wrong'} = 'Ⴂ܂B';
#------------------------------------------------------------------------------------#
if($ENV{'REQUEST_METHOD'} eq "POST"){ read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'})}
else { $buffer = $ENV{'QUERY_STRING'}}
#------------------------------------------------------------------------------------#
@pairs = split(/&/,$buffer);
foreach $pair (@pairs){
   ($name, $value)=split(/=/, $pair);
   $name =~ tr/+/ /;
   $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   if($value =~ /\r\n/){ $value =~ s/\r//g }
   elsif($value =~ /\r/){ $value =~ s/\r/\n/g }
   $value =~ s/\t//g;
   &jcode'h2z_sjis(*value);
   $FORM{$name} = $value;
}
#------------------------------------------------------------------------------------#
$action=$FORM{'action'}; $mode=$FORM{'mode'}; $btn=$FORM{'btn'};
$rmode=$FORM{'rmode'}; $num=$FORM{'num'};

if($mode eq 'an'){ $regdata=$annual; $regttl=$reg{'an'} }
if($mode eq 'mo'){ $regdata=$maidat; $regttl=$reg{'mo'} }
if($mode eq 'wk'){ $regdata=$shudat; $regttl=$reg{'wk'} }

if($action eq 'tei'){ require "$regpl"; &tei }
if($action eq 'reg'){ if($hostpw){ &get_cook }; require "$regpl"; &regform }
if($action eq 'redit'){ require "$regpl"; &chgreg }

if($btn eq $but{'de'}){ $action='edit'; $mode='de' }

($sec,$min,$hour,$today,$mon,$pyear,$pwday,$yday,$isdst)=localtime(time);
$pyear+=1900; $pmonth=$mon+1;

$year=$FORM{'year'}; $month=$FORM{'month'}; $mday=$FORM{'mday'};
$year2=$FORM{'year2'}; $month2=$FORM{'month2'};
if($FORM{'ydata'}){ $year=$FORM{'ydata'} };

if(!$year){ $year=$pyear }
if(!$month){ $month=$pmonth }
if(!$mday){ $mday=$today }

if($month<10) { $dmonth="0$month" } else { $dmonth=$month }
$datafile="data\/$year$dmonth\.dat";

if($action eq 'select'){
   $year =~ s/ //g;
   if($year<1583 || $year>3999){ &print_err("$err{'year'}") }
   $mday=1;
}

if($action eq 'write'){

   if($hostpw){ &get_cook }

   if($month<10) { $wmonth=" $month" } else { $wmonth=$month }
   if($mday<10) { $wmday=" $mday" } else { $wmday=$mday }
   $date="$year/$wmonth/$wmday";

   if($mode eq 're'){
      &read_data;
      $event=$oevent[$mday]; &decode;
      $comment=$msgform{'re'};
   } else { $comment=$msgform{'new'} }
}

if($action eq 'edit'){

	if($uselock){ &lockfile }

   if($hostpw){
      $admpw=$FORM{'admpw'};
      if(!$admpw){ &print_err("$pword$err{'enter'}") }
      if($admpw ne $hostpw){ &print_err("$pword$err{'wrong'}") }
      &set_cook;
   }

   if($mode eq 'de'){$msg=''}
   else {
      $msg=$FORM{'msg'};
      chomp($msg);
      &jcode'convert(*msg,'sjis');
      &encode
   }

   if($mode eq 're' || $mode eq 'de'){
      &read_data;
      $tempfile="data\/tempdata\.dat";
      rename $datafile, $tempfile || &print_err('Error in ReNaming Log File');
      open(EDT,">$datafile") || &print_err("$datafile$err{'open'}");
      chmod 0666, $datafile;
      for($j=1; $j<=$k; $j++){
         ($dmday,$devent)=split(/\t/,$line[$j]);
         if($mday==$dmday){ $line[$j]="$mday\t$msg\n" }
         print EDT "$line[$j]";
      }
      close(EDT);
   } else {
      $newline="$mday\t$msg\n";
   	unless(-e $datafile){
      	open(OUT,">$datafile") || &print_err("$datafile$err{'open'}");
      	chmod 0666, $datafile;
   	} else { open(OUT,">>$datafile") || &print_err("$datafile$err{'open'}") }
      print OUT "$newline";
      close(OUT);
   }

	if($uselock){ unlink($lockfile) }

}

&print_cal;
#------------------------------------------------------------------------------------#
sub lockfile{
   if(-e $lockfile){
      $howlong=(-M $lockfile);
      if(($howlong*24*60)>$locktime){ unlink($lockfile) }
      else { &print_err("ܕҏWłB$locktimeĂ炨B") }
   } else{ open(LCF,">$lockfile"); close(LCF) }
   return 1;
}

sub set_cook{
   $gtime = time + 60*60*24*$cookdays;
   ($gsec,$gmin,$ghour,$gmday,$gmon,$gyear,$gwday,$gyday,$gisdst) = gmtime($gtime);
   $gyear = 1900 + $gyear;
   if ($gsec < 10){ $gsec = "0$gsec" }
   if ($gmin < 10){ $gmin = "0$gmin" }
   if ($ghour < 10){ $ghour = "0$ghour" }
   $gmonth = ($gmon + 1);
   $gwday = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$gwday];
   $gdate = "$gwday, $gmday\-$gmonth\-$gyear $ghour:$gmin:$gsec";
   $gmonth = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$gmon];
   $gwday = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[(gmtime)[6]];
   $cookdate = "$gwday, $gmday\-$gmonth\-$gyear $ghour:$gmin:$gsec GMT";
   $cookies="admpw\:$admpw";
   print "Set-Cookie: $cookname=$cookies; expires=$cookdate\n";
   return 1;
}

sub get_cook{
   foreach(split(/;/,$ENV{'HTTP_COOKIE'})){ ($name, $value)=split(/=/); $name =~ s/ //g; $COOKS{$name}=$value }
   foreach(split(/,/,$COOKS{$cookname})){ ($name, $value)=split(/:/); $COOKS{$name}=$value }
   $admpw=$COOKS{'admpw'};
   return 1;
}
#------------------------------------------------------------------------------------#
sub selecter{
   print <<END_OF_SEL1;
<form name="select" action="$cgi" method="POST">
<input type="hidden" name="action" value="select">
<select name="year">
END_OF_SEL1
   for($x=($pyear-$sel{'last'}); $x<=($pyear+$sel{'next'}); $x++){
      print "<option value=$x";
      if($x==$year){ print " SELECTED" }
      print ">$x\n";
   }
   print <<END_OF_SEL2;
</option></select>
( <input type="text" name="ydata" size=$sel{'box'}> ) N
<select name="month">
END_OF_SEL2

   for($t=1; $t<=12; $t++){
      print "<option value=$t";
      if($t==$month){ print " SELECTED" }
      print ">$t\n";
   }
   print <<END_OF_SEL3;
</option></select> 
<input type="submit" value="$sel{'submit'}">
</form>
<small>$note{'select'}</small>
END_OF_SEL3
   return 1;
}

sub read_data{
   open(IN,"$datafile") || &print_err("$datafile$err{'open'}");
   while(<IN>){
      $k++; $line[$k]=$_;
      ($dmday,$devent)=split(/\t/,$_);
      chomp($devent);
      $oevent[$dmday]=$devent;
   }
   close(IN);
   return 1;
}

sub print_cal{

   @days=(0,31,28,31,30,31,30,31,31,30,31,30,31);
   if ($year%100){ if($year%4){ $leap=0 } else { $leap=1 } }
   else {
     if($year%400){ $leap=0 }
     else { if ($year % 4000) { $leap=1 } else { $leap=0 } }
   }
   if($leap){ $days[2]=29 }

   $mnum=($month-1);
   if($cal{'etsuki'}) {
      $mname = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mnum];
      $hym="$mname. $year";
   } else { $hym="$yearN$month" }

   if($cal{'eyobi1'}) { @wname=('Sun','Mon','Tue','Wed','Thu','Fri','Sat') }
   else { @wname=('','','','','','','y') }

   if($cal{'eyobi2'}) { @lname=('Sun','Mon','Tue','Wed','Thu','Fri','Sat') }
   else { @lname=('','','','','','','y') }

   $fwd=&getwday($year, $month, 1);

   if($year>=1851 && $year<=1899){
      if($month==3){ $shun=int(19.2811+0.242194*($year-1980)-int(($year-1983)/4)) }
      if($month==9){ $shub=int(22.2588+0.242194*($year-1980)-int(($year-1983)/4)) }
   }
   if($year>=1900 && $year<=1979){
      if($month==3){ $shun=int(20.8357+0.242194*($year-1980)-int(($year-1983)/4)) }
      if($month==9){ $shub=int(23.2588+0.242194*($year-1980)-int(($year-1983)/4)) }
   }
   if($year>=1980 && $year<=2099){
      if($month==3){ $shun=int(20.8431+0.242194*($year-1980)-int(($year-1980)/4)) }
      if($month==9){ $shub=int(23.2488+0.242194*($year-1980)-int(($year-1980)/4)) }
   }
   if($year>=2100 && $year<=2150){
      if($month==3){ $shun=int(21.8510+0.242194*($year-1980)-int(($year-1980)/4)) }
      if($month==9){ $shub=int(24.2488+0.242194*($year-1980)-int(($year-1980)/4)) }
   }

   $nyear=$year;
   $next=$month+1;
   if($next==13) { $next=1; $nyear+=1 }

   $lyear=$year;
   $last=$month-1;
   if($last== 0){ $last=12; $lyear-=1 }

   $zyear=($year-1); $yyear=($year+1);

   if(-e $annual) {
      open(SPD,"$annual") || &print_err("$annual$err{'open'}");
      while(<SPD>){
         ($smonth,$smday,$sevent)=split(/\t/,$_);
         if($smonth==$month){
            chomp($sevent);
            $per[$smday]=$sevent;
         }
      }
      close(SPD);
   }

   if(-e $maidat) {
      open(MAI,"$maidat") || &print_err("$maidat$err{'open'}");
      while(<MAI>){
         ($mmday,$mevent)=split(/\t/,$_);
         chomp($mevent);
         $mpr[$mmday]=$mevent;
      }
      close(MAI);
   }

   if(-e $shudat) {
      open(SHU,"$shudat") || &print_err("$shudat$err{'open'}");
      while(<SHU>){
         ($dai,$shuday,$wevent)=split(/\t/,$_);
         chomp($wevent);
         if($dai==1){ $wpr1[$shuday]=$wevent }
         if($dai==2){ $wpr2[$shuday]=$wevent }
         if($dai==3){ $wpr3[$shuday]=$wevent }
         if($dai==4){ $wpr4[$shuday]=$wevent }
         if($dai==5){ $wpr5[$shuday]=$wevent }
      }
      close(SHU);
   }

   if(-e $datafile){ &read_data }

   if(!$repeat){
      &print_header;
      print "<a name=\"top\">$cal{'banner'}</a><br><small><a href=\"$home{'url'}\">[ $home{'name'} ]</a><br><br>\n";
      if($year != $pyear || $month != $pmonth){
         if($mode !~ /list/){
            print "<a href=\"$cgi?action=select\">$cal{'today'}</a> ^\n";
         } else {
            print "<a href=\"$cgi?action=select&mode=slist\">$cal{'today'}</a> ^\n";
         }
      }
   }

   if($mode !~ /list/){
      print <<END_OF_HEAD1;
$cal{'cal'} ^
<a href="$cgi?action=select&mode=slist&year=$year&month=$month">$cal{'list'}</a> ^
$reg{'edit'}
<a href="$cgi?action=tei&mode=an">$reg{'an'}</a> |
<a href="$cgi?action=tei&mode=mo">$reg{'mo'}</a> |
<a href="$cgi?action=tei&mode=wk">$reg{'wk'}</a></small>
<p>
<a href="$cgi?action=select&year=$zyear&month=$month">$cal{'lyear'}</a> &lt;&lt;
<a href="$cgi?action=select&year=$lyear&month=$last">$cal{'lmonth'}</a>
&lt; <b>$hym</b> &gt;
<a href="$cgi?action=select&year=$nyear&month=$next">$cal{'nmonth'}</a> &gt;&gt;
<a href="$cgi?action=select&year=$yyear&month=$month">$cal{'nyear'}</a>
</p>
$cal{'table1'}
<tr>
<th bgcolor="$cal{'cyobi'}" width="15%"><font color="$cal{'wst'}">$wname[0]</font></th>
<th bgcolor="$cal{'cyobi'}" width="14%"><font color="$cal{'wst'}">$wname[1]</font></th>
<th bgcolor="$cal{'cyobi'}" width="14%"><font color="$cal{'wst'}">$wname[2]</font></th>
<th bgcolor="$cal{'cyobi'}" width="14%"><font color="$cal{'wst'}">$wname[3]</font></th>
<th bgcolor="$cal{'cyobi'}" width="14%"><font color="$cal{'wst'}">$wname[4]</font></th>
<th bgcolor="$cal{'cyobi'}" width="14%"><font color="$cal{'wst'}">$wname[5]</font></th>
<th bgcolor="$cal{'cyobi'}" width="15%"><font color="$cal{'wst'}">$wname[6]</font></th>
END_OF_HEAD1

      if($fwd>0){
         print "<tr>";
         if($month==1){ $lmd=31 }
         else { $lmd=$days[$month-1] }
         for($d=($lmd-$fwd+1); $d<=$lmd; $d++){
            print "<td valign=\"top\" align=\"center\">";
            if($cal{'zym'}){ print "<font color=\"$cal{'zym'}\">$d</font>" }
            else { print "<br>" }
            print "</td>\n";
         }
      }

   } else {
      if(!$repeat){
         if($mode eq 'wlistp'){
            $year1=$year; $month1=$month;
            $year=$year2; $month=$month2;
            $nyear=$year;
            $next=$month+1;
            if($next==13) { $next=1; $nyear+=1 }
            $lyear=$year;
            $last=$month-1;
            if($last== 0){ $last=12; $lyear-=1 }
            $zyear=($year-1); $yyear=($year+1);
            $hym="$yearN$month";
         }
         print <<END_OF_HEAD2;
<a href="$cgi?action=select&year=$year&month=$month">$cal{'cal'}</a> ^ $cal{'list'}</small>
<p>
<a href="$cgi?action=select&mode=wlistp&year=$zyear&year2=$year&month=$month&month2=$month">{</a>
<a href="$cgi?action=select&mode=slist&year=$zyear&month=$month">$cal{'lyear'}</a> &lt;&lt;
<a href="$cgi?action=select&mode=wlistp&year=$lyear&year2=$year&month=$last&month2=$month">{</a>
<a href="$cgi?action=select&mode=slist&year=$lyear&month=$last">$cal{'lmonth'}</a>
&lt; <b>$hym</b> &gt;
<a href="$cgi?action=select&mode=slist&year=$nyear&month=$next">$cal{'nmonth'}</a>
<a href="$cgi?action=select&mode=wlistf&year=$year&year2=$nyear&month=$month&month2=$next">{</a> &gt;&gt;
<a href="$cgi?action=select&mode=slist&year=$yyear&month=$month">$cal{'nyear'}</a>
<a href="$cgi?action=select&mode=wlistf&year=$year&year2=$yyear&month=$month&month2=$month">{</a>
<br>
( <small><a href="#ma"></a></small> )
</p>
END_OF_HEAD2
         if($mode =~ /^wlist/){ print "<table cellspacing=0><tr><td valign=\"top\">" }
      }
      print "$cal{'table2'}\n";
      if($mode =~ /^wlist/){
         if(($mode eq 'wlistp') && (!$repeat)){
            $year=$year1; $month=$month1;
            $hym="$yearN$month";
         }
         print "<tr><th colspan=2><a href=\"$cgi?action=select&mode=slist&year=$year&month=$month\">$hym</a></th>\n";
      }
   }

   $wday=$fwd;

   for( $i=1; $i<=$days[$month]; $i++ ) {

      if($i<=7){ $wt=1 }
      if($i>=8 && $i<=14){ $wt=2 }
      if($i>=15 && $i<=21){ $wt=3 }
      if($i>=22 && $i<=28){ $wt=4 }
      if($i>=29){ $wt=5 }

      $nenkan=$shukan=''; $fcheck=0;

      if($wday==0){ $bgcol=$cal{'sun'} }
      if($wday>=1 && $wday<=5) { $bgcol=$cal{'week'} }
      if($wday==6){ $bgcol=$cal{'sat'} }

      if($year>1948 && $month==1 && $i==1){ $nenkan='U'; if($year>1973){ $fcheck=1 } }
      if($year>1966 && $year<2000 && $month==1 && $i==15){ $nenkan='l̓'; if($year>1973){ $fcheck=1 } }
      if($year>1966 && $month==2 && $i==11){ $nenkan='LO'; if($year>1973){ $fcheck=1 } }
      if($month==3 && $i==$shun){ $nenkan='t̓'; if($year>1973){ $fcheck=1 } }
      if($year>1948 && $year<1989 && $month==4 && $i==29){ $nenkan='Vca'; if($year>=1973){ $fcheck=1 } }
      if($year>=1989 && $year<=2006 && $month==4 && $i==29){ $nenkan='݂ǂ̓'; if($year>=1973){ $fcheck=1 } }
      if($year>=2007 && $month==4 && $i==29){ $nenkan='a̓'; if($year>=1973){ $fcheck=1 } }
      if($month==5){
         if($i==3 && $year>1948){ $nenkan='@LO' }
         if($i==4){
            if($year>1985 && $year<=2006){ $nenkan='̋x' }
            if($year>=2007){ $nenkan='݂ǂ̓' }
         }
         if($i==5 && $year>1948){ $nenkan='ǂ̓'; if($year>=1973){ $fcheck=1} }
			if($year>=2007 && $i==6) { if($wday>=2 && $wday<=4) { $nenkan='U֋x' } }
      }
      if($year>=1996 && $year<2003 && $month==7 && $i==20){ $nenkan='C̓'; $fcheck=1 }
      if($month==9 && $i==$shub){ $nenkan='H̓'; if($year>=1973){ $fcheck=1 } }
      if($year>=1966 && $year<2003 && $month==9 && $i==15){ $nenkan='hV̓'; if($year>=1973){ $fcheck=1} }
      if($year>=1966 && $year<2000 && $month==10 && $i==10){ $nenkan='̈̓'; if($year>=1973){ $fcheck=1} }
      if($year>=1948 && $month==11 && $i==3){ $nenkan='̓'; if($year>=1973){ $fcheck=1 } }
      if($year>=1948 && $month==11 && $i==23){ $nenkan='ΘJӂ̓'; if($year>=1973){ $fcheck=1 } }
      if($year>=1989 && $month==12 && $i==23){ $nenkan='Vca'; $fcheck=1 }

      if($wday==1){
         if($year>=2000){
            if($wt==2){
               if($month==1){ $nenkan='l̓' }
               if($month==10){ $nenkan='̈̓' }
            }
         }
         if($year>=2003){
            if($wt==3){
               if($month==7){ $nenkan='C̓' }
               if($month==9){ $sp=$i+1; $nenkan='hV̓' }
            }
         }
      }

      if($year>=2007 && $month==9 && $i==$sp){ if($sp==($shub-1)){ $nenkan='̋x'} }

      if($nenkan){ if(($fcheck) && ($wday==0)){ $fm=$month; $fd=$i+1 } else { $bgcol=$cal{'hol'} } }

      if($wday==1 && $i==$fd && $month==$fm){ $nenkan='U֋x'; $bgcol=$cal{'hol'}; $fm=$fd=0 }

      if(($mode =~ /list/) || ($wday==0)){ print "<tr>" }

      if($mode =~ /list/){ print "<td valign=\"top\" align=\"center\" bgcolor=\"$bgcol\" height=$cal{'td'}>" }
      else { print "<td valign=\"top\" align=\"center\" bgcolor=\"$bgcol\">" }

      if(!$oevent[$i]){ print "<a href=\"$cgi?action=write&mode=new&year=$year&month=$month&mday=$i\">" }
      if($year==$pyear && $month==$pmonth && $i==$today){ print "<b>$i</b>" } else { print "$i" }
      if(!$oevent[$i]){ print "</a>" }

      if($mode =~ /list/){ print "<br>($lname[$wday])</td><td valign=\"top\">" }

      if($wt==1){ $wkdat=$wpr1[$wday] }
      if($wt==2){ $wkdat=$wpr2[$wday] }
      if($wt==3){ $wkdat=$wpr3[$wday] }
      if($wt==4){ $wkdat=$wpr4[$wday] }

      if(($wpr5[$wday]) && ($wkdat)){ $shukan="$wpr5[$wday]<br>$wkdat" }
      if(($wpr5[$wday]) && (!$wkdat)){ $shukan="$wpr5[$wday]" }
      if((!$wpr5[$wday]) && ($wkdat)){ $shukan="$wkdat" }

      if(($nenkan) || ($oevent[$i]) || ($per[$i]) || ($mpr[$i]) || ($shukan)){ print "<small>" }

      if($mode =~ /list/){
         if($nenkan){
            print "$nenkan\n";
            if($per[$i]){ print "<br><font color=\"$cal{'spd'}\">$per[$i]</font>\n" }
            if($mpr[$i]){ print "<br><font color=\"$cal{'mai'}\">$mpr[$i]</font>\n" }
            if($shukan){ print "<br><font color=\"$cal{'shu'}\">$shukan</font>\n" }
            if($oevent[$i]){ print "<br><a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
         } else {
            if($per[$i]){
               print "<font color=\"$cal{'spd'}\">$per[$i]</font>\n";
               if($mpr[$i]){ print "<br><font color=\"$cal{'mai'}\">$mpr[$i]</font>\n" }
               if($shukan){ print "<br><font color=\"$cal{'shu'}\">$shukan</font>\n" }
               if($oevent[$i]){ print "<br><a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
            } else {
               if($mpr[$i]){
                  print "<font color=\"$cal{'mai'}\">$mpr[$i]</font>\n";
                  if($shukan){ print "<br><font color=\"$cal{'shu'}\">$shukan</font>\n" }
                  if($oevent[$i]){ print "<br><a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
               } else {
                  if($shukan){
                     print "<font color=\"$cal{'shu'}\">$shukan</font>\n";
                     if($oevent[$i]){ print "<br><a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
                  } else {
                     if($oevent[$i]){ print "<a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
                  }
               }
            }
         }

      } else {

         if($nenkan){ print "<br>$nenkan\n" }
         if($per[$i]){ print "<br><font color=\"$cal{'spd'}\">$per[$i]</font>\n" }
         if($mpr[$i]){ print "<br><font color=\"$cal{'mai'}\">$mpr[$i]</font>\n" }
         if($shukan){ print "<br><font color=\"$cal{'shu'}\">$shukan</font>\n" }
         if($oevent[$i]){ print "<br><a href=\"$cgi?action=write&mode=re&year=$year&month=$month&mday=$i\">$oevent[$i]</a>\n" }
      }

      if(($nenkan) || ($oevent[$i]) || ($per[$i]) || ($mpr[$i]) || ($shukan)){
      	print "</small>";
      	$oevent[$i]=$per[$i]=$mpr[$i]='';
      } else { if($mode =~ /list/){ print "<br>" } }

      print "</td>\n";

      if($wday==6){ $wday=0 } else { $wday++ }

   }

   if(($mode !~ /list/) && ($wday>0)){
      for($d=1; $d<=(7-$wday); $d++){
         print "<td align=\"center\">";
         if($cal{'zym'}){ print "<font color=\"$cal{'zym'}\">$d</font>" }
         else { print "<br>" }
         print "</td>";
      }
   }

   print "</table>";

   if($mode =~ /^wlist/){
      if(!$repeat){
         print "</td><td valign=\"top\">";
         $repeat=1;
         $year=$year2; $month=$month2;
         if($month<10) { $dmonth="0$month" } else { $dmonth=$month }
         $datafile="data\/$year$dmonth\.dat";
         &print_cal;
      } else { print "</td></table>"; $repeat=0 }
   }

   print "<br><br>\n";

   if($mode !~ /list/){ if($action eq 'write'){ &msgform } else { &selecter } }
   else { print "<a name=\"ma\"><small>[</a> <a href=\"\#top\">TOP</a> ]</small><br>" }

   if(!$action){ print "<table width=\"95%\"><tr><td align=\"right\"><small>$ver</small></td></table>\n" }
	else { print "<br><br>\n" }

   &print_footer;
}
#------------------------------------------------------------------------------------#
sub getwday{
   ($tyear, $tmonth, $tmday) = @_;
   if($tmonth<=2){ $tyear--; $tmonth+=12 }
   return(($tyear+int($tyear/4)-int($tyear/100)+int($tyear/400)+int((13*$tmonth + 8)/5)+$tmday)%7);
}

sub print_header{
   print "Content-type: text/html\n\n";
   print "<html><head>\n";
   print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">\n";
   print "<title>$html{'ttl'}</title>\n";
   if($html{'css'}){ print "<link rel=\"stylesheet\" href=\"$html{'css'}\">\n" }
   print "</head>$html{'body'}\n";
   print "<div align=\"center\"><br>\n";
   return 1;
}

sub print_footer{ print "</div></body></html>\n"; exit }

sub print_err{
   &print_header;
   print "<font color=\"$col{'err'}\">@_</font>\n";
   &print_footer;
}

sub decode{
   $event =~ s/&amp;/&/g;
   $event =~ s/&gt;/>/g;
   $event =~ s/&lt;/</g;
   $event =~ s/<br>/\n/g;
   $event =~ s/&nbsp;&nbsp;&nbsp;/   /g;
   $event =~ s/&nbsp;&nbsp;/  /g;
   return 1;
}

sub encode{
   $msg =~ s/&/&amp;/g;
   $msg =~ s/>/&gt;/g;
   $msg =~ s/</&lt;/g;
   $msg =~ s/\n/<br>/g;
   $msg =~ s/   /&nbsp;&nbsp;&nbsp;/g;
   $msg =~ s/  /&nbsp;&nbsp;/g;
   $msg =~ s/\"/h/g;
   return 1;
}

sub msgform{
   print <<END_OF_MFORM1;
<font color="$col{'comment'}">$comment ( $date )</font><br>
<table cellpadding=8>
<form name="event" method="POST" action="$cgi">
<input type="hidden" name="action" value="edit">
<input type="hidden" name="mode" value="$mode">
<input type="hidden" name="year" value="$year">
<input type="hidden" name="month" value="$month">
<input type="hidden" name="mday" value="$mday">
<tr><td align="center">
<textarea name="msg" rows=$msgform{'rows'} cols=$msgform{'cols'}>$event</textarea><br><br>
END_OF_MFORM1
   if($hostpw){ print "$pword <input type=\"password\" name=\"admpw\" size=$box{'pw'} value=\"$admpw\">\n" }
   print "<input type=\"submit\" name=\"btn\" value=\"$but{'submit'}\">\n";
   print "<input type=\"reset\" value=\"$but{'reset'}\">\n";
   if($event){ print "<input type=\"submit\" name=\"btn\" value=\"$but{'de'}\">" }
   print <<END_OF_MFORM2;
</form></td></table>
<script language="JavaScript">
<!--
document.event.msg.focus();
// -->
</script>
<small><a href="$cgi?action=select&year=$year&month=$month">$msgform{'cal'}</a></small>
END_OF_MFORM2
   return 1;
}


#J_[ PCalen
#Copyright (C) Kyomi Japan All Rights Reserved.
